#define WAVEEDITORTITLE "CyanPhase Basic Effects"
#include "waveditr.h"


//#include "math.h" // uncomment for directwork example

// Uncomment below for directwork example
//
//#define DirectWorkExample

#ifdef DirectWorkExample
class directwork : public CWaveEditorDirectWork {
public:
	virtual char * AboutImplementation();
	virtual void WorkStereo(float *samples, int numsamples, int samplerate);
//	virtual void Stop(); // this gets called when the stop button is clicked,
private:
	double stepthing;
};
#endif

class edit : public CWaveEditor {
public:
	virtual bool __cdecl Init(CCBWaveEditor *pCCB);

	virtual int  __cdecl GetNumOfCommands();
	virtual bool __cdecl EnumerateCommands(int index, char * buffer);

    virtual bool __cdecl Start(int commandindex, int selected);

	// user defined

	virtual void routine_gain(int selected);
	virtual void routine_drop(int selected);

	//

	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);
	virtual int __cdecl WaveEditorVersion() { return 100; };
	virtual void GetExtensionsClass(int param, void **exmodule);
private:
	CCBWaveEditor * pCB;

#ifdef DirectWorkExample
	directwork mydirectwork;
#endif

};

bool edit::Init(CCBWaveEditor *pCCB) {
	pCB = pCCB; // this is for the way to call back and get things
	return true;
}

int  edit::GetNumOfCommands() {
	return 2;
}

bool edit::EnumerateCommands(int index, char * buffer) {
	if (index < 0) return false;
	if (index > 2) return false;
	switch (index) {
	case 0: strcpy(buffer, "Basic Effects - Gain (Twice)"); break;
	case 1: strcpy(buffer, "Basic Effects - Cut (Half)"); break;
	default:
		return false;
		break;
	}
	return true;
}

//////////////////////////////////////////
// Wave Editor Routines That actually does
// Things
//////////////////////////////////////////

void edit::routine_gain(int selected) {
	short * psamples;
	int num;
	int nch;
	int i = 0;
	int u = 0;
	int buf = 0;
	int numnotes = pCB->GetNumOfNotes(selected);

	for (u = 0; u < numnotes; u++) {
		psamples = pCB->GetSamples(selected, u);
		num = pCB->GetNumSamples(selected, u);
		nch = pCB->GetNumChannels(selected);
		for (i = 0; i < (num*nch); i++) {
			buf = (*psamples) * 2;
			if (buf < -32767) buf = -32767;
			if (buf > 32767) buf = 32767;
			*psamples = buf;
			psamples++;
		}
	}
}

void edit::routine_drop(int selected) {
	short * psamples;
	int num;
	int nch;
	int i = 0;
	int u = 0;
	int buf = 0;
	int numnotes = pCB->GetNumOfNotes(selected);

	for (u = 0; u < numnotes; u++) {
		psamples = pCB->GetSamples(selected, u);
		num = pCB->GetNumSamples(selected, u);
		nch = pCB->GetNumChannels(selected);
		for (i = 0; i < (num*nch); i++) {
			buf = (*psamples) / 2;
			if (buf < -32767) buf = -32767;
			if (buf > 32767) buf = 32767;
			*psamples = buf;
			psamples++;
		}
	}
}

//////////////////////////////////////////
// End of Wave Editor Routines
//////////////////////////////////////////

bool edit::Start (int commandindex, int selected) {
	if (selected == -1) {
		MessageBox(NULL, "Please select a sample first in the wavetable.", "Needs a Selection", MB_OK);
	}

	switch (commandindex) {
	case 0:
		routine_gain(selected);
		return true;
		break;
	case 1:
		routine_drop(selected);
		return true;
		break;
	default:
		return false;
	}
	return false;
}

void edit::DispatchCommand(int command_id, int param1, int param2, int param3, int param4) {
}

void edit::DispatchCommandEx(char * str_command, char * str_value) {
	if (strcmp(str_command, "selection") == 0) {
		int selection = (int)str_value;
	}

}

void edit::GetExtensionsClass(int param, void **exmodule) {
#ifdef DirectWorkExample
	if (param == GEC_DIRECTWORK) {
		*exmodule = &mydirectwork;
	}
#endif
}


#ifdef DirectWorkExample
char * directwork::AboutImplementation() {
	return "Sample Direct Work";
	stepthing = 0.0;
}

void directwork::WorkStereo(float *psamples, int numsamples) {
	int i;
	for (i = 0; i < numsamples*2; i++) {
		// crude example, remember to add on to psamples,
		// and not overwrite. this should output a warm
		// bassy sine

		psamples[i] += (float)sin(stepthing) * 12000.0f; // left channel
		i++;
		psamples[i] += (float)sin(stepthing) * 12000.0f; // right channel

		stepthing += 0.01;
		if (stepthing > PI*2.0) { stepthing -= PI*2; }
	}
}
#endif

EXPORTTHING